require("dotenv").config();
const express = require("express");
const axios = require("axios");

const app = express();
const PORT = process.env.PORT;
const BASE_URL = process.env.BASE_URL;
const MAX_PAGE = parseInt(process.env.MAX_PAGE);
const FETCH_INTERVAL = parseInt(process.env.FETCH_INTERVAL);

let lastData = new Set();
let jsonData = [];

async function fetchData() {
    try {
        let newData = new Set();
        let fetchedData = [];

        for (let page = 1; page <= MAX_PAGE; page++) {
            const response = await axios.get(`${BASE_URL}?page=${page}&duration=24h`, {
                headers: {
                    "User-Agent": "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36"
                }
            });

            response.data.data.forEach((item) => {
                if (item.attributes && item.attributes.name) {
                    const cleanedName = item.attributes.name.split('/')[0].trim();
                    newData.add(cleanedName);
                    fetchedData.push(cleanedName);
                }
            });
        }

        jsonData = [...newData]; // JSON verisini güncelle
        lastData = newData;
        console.log("Veri güncellendi:", jsonData);
    } catch (error) {
        console.error("Err:", error.message);
    }
}

fetchData();
setInterval(fetchData, FETCH_INTERVAL);

app.get("/api/data", (req, res) => {
    res.json({ data: jsonData });
});

app.listen(PORT, () => {
    console.log(`Server is running on http://localhost:${PORT}`);
});